/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.coremod.client.gui.modules.WindowListRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingModuleView
extends AbstractBuildingModuleView {
    private String id;
    private JobEntry jobEntry;
    private boolean canLearnCraftingRecipes;
    private boolean canLearnFurnaceRecipes;
    private boolean canLearnLargeRecipes;
    protected final List<IRecipeStorage> recipes = new ArrayList<IRecipeStorage>();
    private int maxRecipes;
    private boolean isVisible = false;

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        this.jobEntry = buf.readBoolean() ? (JobEntry)buf.readRegistryIdSafe(JobEntry.class) : null;
        this.canLearnCraftingRecipes = buf.readBoolean();
        this.canLearnFurnaceRecipes = buf.readBoolean();
        this.canLearnLargeRecipes = buf.readBoolean();
        this.recipes.clear();
        int recipesSize = buf.readInt();
        for (int i = 0; i < recipesSize; ++i) {
            IRecipeStorage storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(buf.func_150793_b());
            if (storage == null) continue;
            this.recipes.add(storage);
        }
        this.maxRecipes = buf.readInt();
        this.id = buf.func_150789_c(Short.MAX_VALUE);
        this.isVisible = buf.readBoolean();
    }

    @Nullable
    public JobEntry getJobEntry() {
        return this.jobEntry;
    }

    public boolean isRecipeAlterationAllowed() {
        return this.canLearnCraftingRecipes || this.canLearnFurnaceRecipes;
    }

    public boolean canLearnCraftingRecipes() {
        return this.canLearnCraftingRecipes;
    }

    public boolean canLearnFurnaceRecipes() {
        return this.canLearnFurnaceRecipes;
    }

    public boolean canLearnLargeRecipes() {
        return this.canLearnLargeRecipes;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isPageVisible() {
        return this.isVisible;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Window getWindow() {
        return new WindowListRecipes(this.buildingView, "minecolonies:gui/layouthuts/layoutlistrecipes.xml", this);
    }

    @Override
    public String getIcon() {
        return this.id;
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.coremod.gui.workerhuts.recipe." + this.id;
    }

    public List<IRecipeStorage> getRecipes() {
        return this.recipes;
    }

    public void removeRecipe(int index) {
        this.recipes.remove(index);
    }

    public void switchOrder(int i, int j) {
        if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
            IRecipeStorage storage = this.recipes.get(i);
            this.recipes.set(i, this.recipes.get(j));
            this.recipes.set(j, storage);
        }
    }

    public int getMaxRecipes() {
        return this.maxRecipes;
    }
}

